/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ComparatorMode;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import vazkii.botania.api.item.ICosmeticAttachable;
import vazkii.botania.api.item.ICosmeticBauble;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;
import vazkii.botania.common.lib.ModTags;
import vazkii.botania.common.proxy.IProxy;

public class ItemMonocle
extends ItemBauble
implements ICosmeticBauble {
    public ItemMonocle(Item.Properties props) {
        super(props);
        IProxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
    }

    public static boolean hasMonocle(LivingEntity living) {
        return !EquipmentHandler.findOrEmpty(stack -> {
            if (!stack.m_41619_()) {
                Item item = stack.m_41720_();
                if (stack.m_204117_(ModTags.Items.BURST_VIEWERS)) {
                    return true;
                }
                if (item instanceof ICosmeticAttachable) {
                    ICosmeticAttachable attach = (ICosmeticAttachable)item;
                    ItemStack cosmetic = attach.getCosmeticItem((ItemStack)stack);
                    return !cosmetic.m_41619_() && cosmetic.m_204117_(ModTags.Items.BURST_VIEWERS);
                }
            }
            return false;
        }, living).m_41619_();
    }

    public static class Renderer
    implements AccessoryRenderer {
        @Override
        public void doRender(HumanoidModel<?> bipedModel, ItemStack stack, LivingEntity living, PoseStack ms, MultiBufferSource buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            bipedModel.f_102808_.m_104299_(ms);
            ms.m_85837_(0.15, -0.2, -0.25);
            ms.m_85841_(0.3f, -0.3f, -0.3f);
            Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.NONE, light, OverlayTexture.f_118083_, ms, buffers, living.m_142049_());
        }
    }

    public static class Hud {
        public static void render(PoseStack ms, Player player) {
            Minecraft mc = Minecraft.m_91087_();
            HitResult ray = mc.f_91077_;
            if (ray == null || ray.m_6662_() != HitResult.Type.BLOCK) {
                return;
            }
            BlockPos pos = ((BlockHitResult)ray).m_82425_();
            BlockState state = player.f_19853_.m_8055_(pos);
            player.f_19853_.m_7702_(pos);
            ItemStack dispStack = ItemStack.f_41583_;
            Object text = "";
            if (state.m_60713_(Blocks.f_50088_)) {
                dispStack = new ItemStack((ItemLike)Items.f_42451_);
                text = "" + ChatFormatting.RED + state.m_61143_((Property)RedStoneWireBlock.f_55500_);
            } else if (state.m_60713_(Blocks.f_50146_)) {
                dispStack = new ItemStack((ItemLike)Blocks.f_50146_);
                text = "" + state.m_61143_((Property)RepeaterBlock.f_55798_);
            } else if (state.m_60713_(Blocks.f_50328_)) {
                dispStack = new ItemStack((ItemLike)Blocks.f_50328_);
                Object object = text = state.m_61143_((Property)ComparatorBlock.f_51854_) == ComparatorMode.SUBTRACT ? "-" : "+";
            }
            if (dispStack.m_41619_()) {
                return;
            }
            int x = mc.m_91268_().m_85445_() / 2 + 15;
            int y = mc.m_91268_().m_85446_() / 2 - 8;
            mc.m_91291_().m_115203_(dispStack, x, y);
            mc.f_91062_.m_92750_(ms, (String)text, (float)(x + 20), (float)(y + 4), 0xFFFFFF);
        }
    }
}

